﻿using System;
using System.Collections;
using System.Web.UI;
using Soneta.Kadry;
using Soneta.Business;
using Soneta.Types;
using Soneta.Tools;
using Soneta.Kasa;
using Soneta.Place;
using System.ComponentModel;
using Soneta.Core;

namespace ASP {
    
    public partial class Zaświadczenie_O_Zarobkach : System.Web.UI.Page {

        public string Str_CultureInfo = "pl-PL";
        public string Str_Pan = "Pan:";
        public string Str_Zamieszkaly = "Zamieszkały:";
        public string Str_Zameldowany = "Zameldowany:";
        public string Str_Pani = "Pani:";
        public string Str_Zamieszkala = "Zamieszkała:";
        public string Str_Zameldowana = "Zameldowana:";
        public string Str_Zatrudniony = "zatrudniony";
        public string Str_Zatrudniona = "zatrudniona";
        public string Str_InfoEtat = "jest {0} w naszym zakładzie pracy <b>{1}</b><br>od dnia: <b>{2}</b> do dnia: {3}<br>na stanowisku: <b>{4}</b>.";
        public string Str_InfoZlec = "wykonuje pracę w naszym zakładzie na podstawie umowy zlecenia/o dzieło.";
        public string Str_JestObciazenie = "Wynagrodzenie to jest obciążone z tytułu wyroków sądowych lub innych tytułów:";
        public string Str_BrakObciazenia = "Wynagrodzenie to nie jest obciążone z tytułu wyroków sądowych lub innych tytułów.";
        public string Str_OstatniMiesiac = "ostatniego miesiąca";
        public string Str_Ostatnie2Miesiace = "ostatnich dwóch miesięcy";
        public string Str_Ostatnie3Miesiace = "ostatnich trzech miesięcy";
        public string Str_Ostatnie4Miesiace = "ostatnich czterech miesięcy";
        public string Str_Ostatnie5Miesiecy = "ostatnich pięciu miesięcy";
        public string Str_Ostatnie6Miesiecy = "ostatnich sześciu miesięcy";
        public string Str_OstatnieNMiesiecy = "ostatnich {0} miesięcy";
        public string Str_TytulObciazenia = "Jest obciążone z tytułu:";
        public string Str_ReportTitle = "<center>Zaświadczenie o zarobkach</center>|<p align=right></strong>{0}, {1}<strong></p>";

	    //Elementy wg nazwy
	    //Tutaj wpisujemy nazwy elementów które mają zostać uwzględnione w zesatwieniu nawet jeżeli
	    //nie spełniają innych kryteriów.
	    //Każda nazwa musi być wpisana w '"' i oddzielona ',' od następnej.
	    static readonly string[] nazwyDodatków = new string[] {};

	    //A tutaj tak samo, ale elementy, które mają być zawsze pominięte    
        static readonly string[] pomińDodatki = new string[] { };
		    	
	    //Uwzględniemy wszystkie elementy opodatkowane ewentualnie poza zaliczkami
	    //Oraz elementy nieopodatkowane wg podanych założeń	
	    Hashtable wyjatki = null;
	    bool Wchodzi(WypElement e) {
		    if (wyjatki==null) {
			    wyjatki = new Hashtable();
			    foreach (string nazwa in nazwyDodatków)
				    wyjatki[nazwa.ToLower()] = true;
                foreach (string nazwa in pomińDodatki )
                    wyjatki[nazwa.ToLower()] = false;
            }
		
            object obj = wyjatki[e.Definicja.Nazwa.ToLower()];
		    if (obj!=null)
			    return (bool)obj;

            if (!e.Definicja.DoWyplaty)
                return false;
            
		    if (e.Definicja.Info.Opodatkowany)
			    switch (e.RodzajZrodla) {
				    case RodzajŹródłaWypłaty.Zaliczka:
				    case RodzajŹródłaWypłaty.SpłataZaliczki:
					    return srpars.ZaliczkiISplatyOpodatkowane;
				    default:
					    return true;
			    }
			
		    switch (e.RodzajZrodla) {
			    case RodzajŹródłaWypłaty.Zaliczka:
			    case RodzajŹródłaWypłaty.SpłataZaliczki:
				    return srpars.ZaliczkiISplatyNieopodatkowane;

			    case RodzajŹródłaWypłaty.Pożyczka:
			    case RodzajŹródłaWypłaty.PożyczkaSpłata:
				    return srpars.PozyczkiISplaty;
				
			    default:
				    return !e.Definicja.Info.Potrącenie ? srpars.DodatkiNieopodatkowane : srpars.PotraceniaNieopodatkowane;
		    }		
	    }
	
        public class PrnParams: Soneta.Business.OkresContext {
    
            public PrnParams(Context context): base(context) {
                wgDatyWypłaty = true;
                YearMonth to = new YearMonth(Aktualny);
                to -= 1;
                YearMonth from = to - 2;
                base.Okres = new FromTo(from.FirstDay, to.LastDay);
            }
    
            [Browsable(false)]
		    [Caption("Aktualny")]
            public override Date Aktualny {
                get { return base.Aktualny; }
                set { base.Aktualny = value; }
            }
    
    
            [Priority(1)]
		    [Caption("Okres")]
            public override FromTo Okres {
                get { return base.Okres; }
                set {
                    if (value == FromTo.Empty)
                        value = FromTo.All;
                    base.Okres = value;
                }
            }
    
            bool wgDatyWypłaty;
            [Priority(2)]
		    [Caption("Wg Daty Wypłaty")]
            public bool WgDatyWypłaty {
                get { return wgDatyWypłaty; }
                set {
                    wgDatyWypłaty = value;
                    OnChanged(EventArgs.Empty);
                }
            }
    
            bool etat = true;
            [Priority(3)]
		    [Caption("Wypłaty Za Etat")]
            public bool WypłatyZaEtat {
                get { return etat; }
                set {
                    etat = value;
                    OnChanged(EventArgs.Empty);
                }
            }
    
            bool umowa = false;
            [Priority(4)]
		    [Caption("Umowy")]
            public bool Umowy {
                get { return umowa; }
                set {
                    umowa = value;
                    OnChanged(EventArgs.Empty);
                }
            }
    
            bool inne = false;
		    [Priority(5)]
		    [Caption("Inne Wypłaty")]
            public bool InneWypłaty {
                get { return inne; }
                set {
                    inne = value;
                    OnChanged(EventArgs.Empty);
                }
            }

		    bool pozostajeZero = false;
		    [Priority(6)]
		    [Caption("Pozostaje Zero")]
		    public bool PozostajeZero
		    {
			    get { return pozostajeZero; }
			    set {
				    pozostajeZero = value;
				    OnChanged(EventArgs.Empty);
			    }
		    }
        }

	    public class SrParams : SerializableContextBase {

		    public SrParams(Context context) : base(context) {
		    }

		    //W raporcie uwzględniaj następujące elementy nieopodatkowane:
		    //Pożyczki i spłaty pożyczek
		    //static readonly bool pozyczkiISplaty = false;
		    bool pozyczkiISplaty = false;
		    [Priority(1)]
		    [Caption("Pożyczki i spłaty")]
		    public bool PozyczkiISplaty {
			    get { return pozyczkiISplaty; }
			    set {
				    pozyczkiISplaty = value;
				    OnChanged(EventArgs.Empty);
			    }
		    }

		    //Zaliczki opodatkowane i ich spłaty
		    //static readonly bool zaliczkiISplatyOpodatkowane = false;
		    bool zaliczkiISplatyOpodatkowane = false;
		    [Priority(2)]
		    [Caption("Zalicz. i spłaty opodatk.")]
		    public bool ZaliczkiISplatyOpodatkowane {
			    get { return zaliczkiISplatyOpodatkowane; }
			    set {
				    zaliczkiISplatyOpodatkowane = value;
				    OnChanged(EventArgs.Empty);
			    }
		    }

		    //Zaliczki nieopodatkowane i ich spłaty
		    //static readonly bool zaliczkiISplatyNieopodatkowane = false;
		    bool zaliczkiISplatyNieopodatkowane = false;
		    [Priority(3)]
		    [Caption("Zalicz. i spł. nieopodatk.")]
		    public bool ZaliczkiISplatyNieopodatkowane {
			    get { return zaliczkiISplatyNieopodatkowane; }
			    set {
				    zaliczkiISplatyNieopodatkowane = value;
				    OnChanged(EventArgs.Empty);
			    }
		    }

		    //Dodatki nieopodatkowane
		    //static readonly bool dodatkiNieopodatkowane = true;
		    bool dodatkiNieopodatkowane = true;
		    [Priority(4)]
		    [Caption("Dodatki nieopodatk.")]
		    public bool DodatkiNieopodatkowane {
			    get { return dodatkiNieopodatkowane; }
			    set {
				    dodatkiNieopodatkowane = value;
				    OnChanged(EventArgs.Empty);
			    }
		    }

		    //Potrącenie nieopodatkowane
		    //static readonly bool potraceniaNieopodatkowane = false;
		    bool potraceniaNieopodatkowane = false;
		    [Priority(5)]
		    [Caption("Potrącenia nieopodatk.")]
		    public bool PotraceniaNieopodatkowane {
			    get { return potraceniaNieopodatkowane; }
			    set {
				    potraceniaNieopodatkowane = value;
				    OnChanged(EventArgs.Empty);
			    }
		    }

		    //Podsumowanie funduszy pożyczkowych
		    //static readonly bool podsumowanieFunduszy = false;    
		    bool podsumowanieFunduszy = false;
		    [Priority(6)]
		    [Caption("Podsum. funduszy")]
		    public bool PodsumowanieFunduszy {
			    get { return podsumowanieFunduszy; }
			    set {
				    podsumowanieFunduszy = value;
				    OnChanged(EventArgs.Empty);
			    }
		    }
	    }
	
        PrnParams pars;
        [Soneta.Business.Context(Required=true)]
        public PrnParams Params {
            get { return pars; }
            set { pars = value; }
        }

	    SrParams srpars;
	    [SettingsContext]
	    public SrParams SrPars {
		    get { return srpars; }
		    set { srpars = value; }
	    }

        protected void OnContextLoad(Object sender, EventArgs args) {
            ReportHeader1.Title = String.Format(Str_ReportTitle,
                CoreModule.GetInstance(dc).Config.Firma.AdresSiedziby.Miejscowosc,
                pars.Aktualny);

            System.Globalization.CultureInfo ci = new System.Globalization.CultureInfo(Str_CultureInfo);

            Pracownik pracownik = (Pracownik)dc[typeof(Pracownik)];
            PracHistoria historia = pracownik[pars.Aktualny];
            string zameldowany = "";
				
            if (historia.Plec != 0) {
				Pan.EditValue = Str_Pan;
				Zamieszkały.EditValue = Str_Zamieszkaly;
				zameldowany = String.Format("<br/>{0}:", Str_Zameldowany);
            }
            else {
				Pan.EditValue = Str_Pani;
				Zamieszkały.EditValue = Str_Zamieszkala;
				zameldowany = String.Format("<br/>{0}:", Str_Zameldowana);
            }

            if (!historia.AdresZamieszkania.IsEmpty())
                Zameldowany.EditValue = zameldowany + " <strong>" + historia.AdresZameldowania.Linia1 + ", " + historia.AdresZameldowania.Linia2 + "</strong>";


            Pracownik.EditValue = pracownik.ImięNazwisko;
            Adres.EditValue = historia.Adres.Linia1 + ", " + historia.Adres.Linia2;
            Pesel.EditValue = historia.PESEL;

            if (pars.WypłatyZaEtat) {
				string zatrudniony = Str_Zatrudniony;
				string zatrudniona = Str_Zatrudniona;
				string infoEtat = Str_InfoEtat;
					
                FromTo okres = historia.Etat.OkresZatrudnienia;
                string sto = okres.To == Date.MaxValue ? ". . . . . . . . . . . . . . ." : "<b>" + okres.To + "</b>";
                string płeć = historia.Plec != 0 ? zatrudniony : zatrudniona;
				Info.EditValue = String.Format(infoEtat, płeć, CaptionAttribute.EnumToString(historia.Etat.TypUmowy, ci).ToLower(), okres.From, sto, historia.Etat.Stanowisko);
            }
            else
				Info.EditValue = Str_InfoZlec;

            decimal brutto = 0;
            decimal netto = 0;

            SubTable elementy;
            PlaceModule płace = PlaceModule.GetInstance(pracownik);

			ArrayList listZajecia = new ArrayList();
			ArrayList listAlimenty = new ArrayList();

			Date data = ((ActualDate)dc[typeof(ActualDate)]).Actual;

            foreach (Pracownik pp in pracownik.PracownicyPowiązani) {
                if (pars.WgDatyWypłaty)
                    elementy = płace.WypElementy.WgDaty[pp];
                else
                    elementy = płace.WypElementy.WgPracownik[pp];
                elementy = new SubTable(elementy, pars.Okres);

                foreach (WypElement e in elementy) {
                    if (!e.Wyplata.Zatwierdzona)
                        continue;
                    if (Wchodzi(e)) {
                        bool ok;
                        switch (e.Wyplata.Typ) {
                            case TypWyplaty.Etat:
                                ok = pars.WypłatyZaEtat; break;
                            case TypWyplaty.Umowa:
                                ok = pars.Umowy; break;
                            default:
                                ok = pars.InneWypłaty; break;
                        }

                        if (ok) {
                            if (e.Definicja.Info.Opodatkowany)
                                brutto += e.Wartosc;
                            netto += e.Netto;
                        }
                    }
                }
					
				foreach (ZajęcieKomornicze zk in pp.ZajęciaKomornicze) {
					if (zk.Data > pars.Okres.To)
						continue;
					if (pars.PozostajeZero) {
						if (pars.Okres.To >= data && zk.DataSplaty < data)
							continue;
					} else {
						if (zk.DataSplaty < data)
							continue;
					}
					if (zk.Element.Nazwa == "Alimenty")
						listAlimenty.Add(zk);
					else
						listZajecia.Add(zk);
				}
			}

			if (listZajecia.Count > 0 || listAlimenty.Count > 0)
				labelZajecia.EditValue = Str_JestObciazenie;
			else
				labelZajecia.EditValue = Str_BrakObciazenia;

			if (listZajecia.Count > 0)
				Grid1.DataSource = listZajecia;
			else
				Grid1.Visible = false;

			if (listAlimenty.Count > 0)
				Grid2.DataSource = listAlimenty;
			else
				Grid2.Visible = false;

            int m = pars.Okres.Months;
            if (m != 0) {
                brutto = Soneta.Tools.Math.RoundCy(brutto/m);
                netto = Soneta.Tools.Math.RoundCy(netto/m);
            }

            Brutto.EditValue = Currency.SłownieWalutaUpr(brutto);
            Słownie.EditValue = this.Slownie(brutto);

            Netto.EditValue = Currency.SłownieWalutaUpr(netto);
			SłownieNetto.EditValue = this.Slownie(netto);

            string ms;
            switch (m) {
                case 1:
                    ms = Str_OstatniMiesiac; break;
                case 2:
                    ms = Str_Ostatnie2Miesiace; break;
                case 3:
                    ms = Str_Ostatnie3Miesiace; break;
                case 4:
                    ms = Str_Ostatnie4Miesiace; break;
                case 5:
                    ms = Str_Ostatnie5Miesiecy; break;
                case 6:
                    ms = Str_Ostatnie6Miesiecy; break;
                default:
                    ms = String.Format(Str_OstatnieNMiesiecy, m); break;
            }
            miesiace1.EditValue = ms;
            miesiace2.EditValue = ms;

            if (srpars.PodsumowanieFunduszy) {
                FundPożyczkowyWorker worker = new FundPożyczkowyWorker();
                string ss = "";
                foreach (FundPozyczkowy fp in pracownik.FunduszePozyczkowe) {
                    worker.Fundusz = fp;
                    Currency saldo = worker.DoSpłaty - worker.Wkład;
                    if (saldo > 0)
                        ss += string.Format("<tr><td width=60%>{0}</td><td><b>{1:u}</b></td></tr>",
                            fp.Definicja.Nazwa, saldo);
                }

                if (ss != "")
                    labelFundusze.EditValue = String.Format("<br/><br/><table width=100% style=\"font-size: 10pt; font-family: tahoma;\">" +
														"<tr><td colspan=2>{0}</td></tr>{1}</table>", Str_TytulObciazenia, ss);
            }
        }

        protected void Grid1_BeforeRow(object sender, Soneta.Web.RowEventArgs args) {
			ZajęcieKomornicze zk = (ZajęcieKomornicze)args.Row;

			Grid1Column1.EditValue = zk.Element.Nazwa;
			Grid1Column2.EditValue = zk.NumerSprawy;
			if (zk.Rodzaj == RodzajeZajęciaWynagrodzenia.Kwota) {
				Grid1Column3.EditValue = zk.Kwota.Value;
				Grid1Column5.EditValue = zk.Pozostało.Value;
			}
			else
				Grid1Column4.EditValue = zk.Kwota.Value;
			if (zk.DataSplaty != Date.MaxValue)
				Grid1Column6.EditValue = zk.DataSplaty;
		}

        protected void Grid2_BeforeRow(object sender, Soneta.Web.RowEventArgs args) {
			ZajęcieKomornicze zk = (ZajęcieKomornicze)args.Row;

			Grid2Column1.EditValue = zk.Element.Nazwa;
			Grid2Column2.EditValue = zk.NumerSprawy;
			if (zk.Rodzaj == RodzajeZajęciaWynagrodzenia.Kwota) {
				Grid2Column3.EditValue = zk.Kwota.Value;
				Grid2Column5.EditValue = zk.Pozostało.Value;
			}
			else
				Grid2Column4.EditValue = zk.Kwota.Value;
			if (zk.DataSplaty != Date.MaxValue)
				Grid2Column6.EditValue = zk.DataSplaty;
		}

		private string Slownie(decimal value) {
			string result = String.Empty;
            string currentCi = CoreTools.GetCultureName(System.Threading.Thread.CurrentThread.CurrentUICulture);
            string engCi = CoreTools.GetCultureName(CoreTools.CultureEN);
            if (currentCi == engCi)
				result = Currency.SłownieWalutaEng(value, "");
			else
				result = Currency.SłownieWaluta(value);
			return result;
		}
    }
}
